//
//  list.c
//  logMollo
//
//  Created by Gwendal Le Tareau on 10/11/2022.
//

#include <stdio.h>
#include "list.h"


struct _list_node {
    void * data;
    struct _list_node * next;
};
typedef struct _list_node s_node;

// création d'une nouvelle liste vide
s_node * list_create(void)
{
    s_node sn = {
        .data = NULL,
        .next = NULL
    };
    return &sn;
}

// création et insertion d'un nœud en tête de liste (retourne la tête de liste)
s_node * list_insert(s_node * head, void * data)
{
    s_node sn = {
        .data = data,
        .next = head
    };
    return &sn;
}

// création et insertion d'un nœud en queue de liste (retourne la tête de liste)
s_node * list_append(s_node * head, void * data);


s_node * list_append2(s_node ** head, s_node * queue, void * data);

// suppression de la première instance d'une donnée dans la liste (retourne la tête de liste)
s_node * list_remove(s_node * head, void * data);

// suppression de la tête de liste (retorune la nouvelle tête de liste
s_node * list_headRemove(s_node * head);

// desctruction d'une liste (la libération des données n'est pas prise en charge)
s_node * list_destroy(s_node * head);

int list_process(s_node * head, int (*fct)(s_node * node, void * param), void * param, s_node ** last);

int list_isEmpty(s_node * head);

// ajout d'un nœud dans une liste ordonnée selon le résultat de "compare"; si la donnée existe déjà, elle n'est pas ajoutée (retourne la tête de liste)
s_node * list_orderedAppend(s_node ** head, int (*compare)(s_node *, void *), void *param);

// nœud suivant de la liste

s_node * list_next(s_node * node)
{
    return node->next;
}
